// SCTS_Test.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "windows.h"
#include "stdio.h"
#include "conio.h"
#include "stdlib.h"
#include "SCTS.h"

typedef struct
{
	HANDLE userevent;
	ULONG nSampleCount;
	int intvec;
	int event;
} MY_EXTENSION, *PMY_EXTENSION;

PMY_EXTENSION pExtension;

void UserISR(sctsctl_t board, int intvec)
{
	PMY_EXTENSION pExtension = (PMY_EXTENSION)SCTSCTL_GET_EXTENSION(board);
	Sleep(10);
	pExtension->nSampleCount++; 
	pExtension->intvec = intvec;
    Sleep(280);
	SetEvent(pExtension->userevent);
}

int main(int argc, char* argv[])
{
    int board_index = 0; 
	sctsctl_t board0;
	int execnt = 0;
	int sleeptime = 10;
	int status = 0;
	int error = 0;
	int total_error = 0;
	int verbose = 0;
	double volt;
	double current;

	if (argc > 1)
	{
		board_index = atoi(argv[1]);
	} 
	if (argc > 2) verbose = 1;

	board0 = SCTSCTL_OPEN(0);
	if (board0->hDevice == PCITG_NULL)
	{
		printf("No PCI SCTS Card Found On System !\n\n");
		printf("Please Contact Soliton Tech. Co, LTD.\n");
		printf("http://www.soliton.com.tw\n\n");						
		return 1;
	} 
	else
	{
		printf("Board[%d] found, Device Handle = 0x%.8X\n", board_index, board0->hDevice);
	}

	SCTSCTL_CARDSERVICE_INIT(board0);	

	HANDLE UserISREvent;
	DWORD dwWaitResult;
	PMY_EXTENSION pExtension = NULL;

	UserISREvent = CreateEvent(NULL, TRUE, FALSE, NULL);

	pExtension = (PMY_EXTENSION)malloc(sizeof(MY_EXTENSION));
	pExtension->nSampleCount = 0;
	pExtension->userevent = UserISREvent;
	SCTSCTL_SET_EXTENSION(board0, pExtension);	
	SCTSCTL_CONNECT(board0, UserISR);

	Sleep(100);
	printf("Wait for INT Kit!\n");

	while(!kbhit())
	{
		dwWaitResult = WaitForSingleObject(UserISREvent, 3000);
		if (dwWaitResult == WAIT_TIMEOUT)
		{
			/*
		   	double measu;
			SCTSCTL_MEAS_VOLTAGE(board0, &volt);
			measu=0;
				for(int i=0; i<10; i++)
				{				
					SCTSCTL_MEAS_CURRENT(board0, &current);
					Sleep(100);
					if(current > 0)
					{	
						measu+= current;
					}
				}		
			printf("V=[%f]V  I=[%f]mA\n", volt, current*1e3);
			*/


		}
		else if (dwWaitResult == WAIT_OBJECT_0)
		{
			printf("\n");
			switch (pExtension->intvec)
			{
			case SCTS_EVENT_SDMMCCARD_INSERT:
			case SCTS_EVENT_MSCARD_INSERT:
			case SCTS_EVENT_XDCARD_INSERT:
				status = SCTSCTL_CARDINSERTPROCESS(board0, &volt, &current);
				if (status == 0)
				{
					printf("Card Insert Process OK! V=[%f]V I=[%f]mA\n", volt, current*1e3);
				}
				else
				{
					printf("Card Insert Process Fail!\n");
				}

			break;
			case SCTS_EVENT_SDMMCCARD_REMOVE:
			case SCTS_EVENT_MSCARD_REMOVE:
			case SCTS_EVENT_XDCARD_REMOVE:
				status = SCTSCTL_CARDREMOVEPROCESS(board0);
				if (status == 0) 
				{
					printf("Card Removed OK\n");
				}
				else 
				{
					printf("Card Removed Fail\n");
				}


			break;
			case SCTS_EVENT_CARDPOWER_OC:
				status = SCTSCTL_CARDOCPROCESS(board0);
				if(status != 0)
				{
					printf("Short circuit detected on 3.3V by PCI SCTS .\n");
				}
			break;
			default:
				// Do nothing
			break;

			}

			ResetEvent(UserISREvent);
		}

	}

	SCTSCTL_CARDSERVICE_EXIT(board0);	// Normal
	SCTSCTL_CLOSE(board0);
	return 0;
}

